#!/usr/bin/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, print_function

import urllib2 as u2
import xml.etree.ElementTree as ET
import collections as col
import sys, codecs, locale
sys.stdout = codecs.getwriter(locale.getpreferredencoding())(sys.stdout)

Stat = col.namedtuple('Stat', ['count', 'name', 'branch', 'work',
                               'untranslated','fuzzy', 'translated', 'total'])

titles = Stat(count=('Номер', 'rjust'), name=('Име', 'ljust'),
              branch=('Клон', 'ljust'), work=('Работа', 'rjust'),
              untranslated=('Непреведени', 'rjust'),  fuzzy=('Мъгляви', 'rjust'),
              translated=('Преведени', 'rjust'), total=('Всичко', 'rjust'))

#titles = Stat(count=('Number', 'rjust'), name=('Name', 'ljust'),
#              branch=('Branch', 'ljust'), work=('Work', 'ljust'),
#              untranslated=('Untranslated', 'ljust'),  fuzzy=('Fuzyy', 'rjust'),
#              translated=('Translated', 'rjust'), total=('All', 'rjust'))


def get_versions():
    versions_url = 'https://l10n.gnome.org/releases/xml'
    versions_data = u2.urlopen(versions_url)

    versions_tree = ET.parse(versions_data)
    versions_root = versions_tree.getroot()
    versions_xpath = './object/field[@name="name"]'
    version_elements = versions_root.findall(versions_xpath)
    versions = [e.text for e in version_elements]
    return versions


def get_stats(version):
    stats_url = 'https://l10n.gnome.org/languages/bg/{}/xml'.format(version)
    stats_data = u2.urlopen(stats_url)
    stats_tree = ET.parse(stats_data)
    stats_root = stats_tree.getroot()
    stats_xpath = './category/module'
    stats_elements = stats_root.findall(stats_xpath)
    results = []
    for stats_el in stats_elements:
        stat_id = stats_el.attrib['id']
        stat_branch = stats_el.attrib['branch']
        domains = stats_el.findall('./domain')
        for dom in domains:
            dom_id = dom.attrib['id']
            if dom_id == 'po':
                name = stat_id
            elif dom_id.startswith('po-'):
                name = '{}-{}'.format(stat_id, dom_id[3:])
            else:
                name = '{}-{}'.format(stat_id ,dom_id)
            translated = int(dom.findtext('./translated'))
            fuzzy = int(dom.findtext('./fuzzy'))
            untranslated  = int(dom.findtext('./untranslated'))
            work = fuzzy + untranslated
            total = work + translated
            s = Stat(count=None, name=name, branch=stat_branch,
                     translated=translated, fuzzy=fuzzy,
                     untranslated=untranslated, work=work, total=total)
            results.append(s)
    # sorts are stable
    results.sort(key=lambda s: s.name)
    results.sort(key=lambda s: s.fuzzy, reverse=True)
    results.sort(key=lambda s: s.untranslated, reverse=True)
    results.sort(key=lambda s: s.work, reverse=True)
    for i, s in enumerate(results):
        results[i] = s._replace(count=i+1)
    return results


def stats_max_lengths_sums(stats):
    name = 0
    branch = 0
    sum_translated = 0
    sum_fuzzy = 0
    sum_untranslated = 0
    sum_work = 0
    sum_total = 0

    for s in stats:
        name = max(name, len(s.name))
        branch = max(branch, len(s.branch))
        sum_translated = sum_translated + s.translated
        sum_fuzzy = sum_fuzzy + s.fuzzy
        sum_untranslated = sum_untranslated + s.untranslated
        sum_work = sum_work + s.work
        sum_total = sum_total + s.total

    max_len = Stat(count=len(str(len(stats))), name=name, branch=branch,
                   translated=len(str(sum_translated)), fuzzy=len(str(sum_fuzzy)),
                   untranslated=len(str(sum_untranslated)), work=len(str(sum_work)),
                   total=len(str(sum_total)))
    sums = Stat(count=len(stats), name='', branch='', translated=sum_translated,
                fuzzy=sum_fuzzy, untranslated=sum_untranslated, work=sum_work,
                total=sum_total)
    return {'max_len': max_len, 'sums': sums}


def divider(s):
    inner = '┼'.join(['─' * (f + 1) for f in s]) 
    return '├' + inner + '┤' 

def start(s):
    inner = '┬'.join(['─' * (f + 1) for f in s]) 
    return '┌' + inner + '┐' 

def end(s):
    inner = '┴'.join(['─' * (f + 1) for f in s]) 
    return '└' + inner + '┘' 

def ellipsis(s):
    inner = '┼'.join(['⋯' * (f + 1) for f in s]) 
    return '├' + inner + '┤' 


def stat_line(max_len, s):
    args = []
    for i in range(len(max_len)):
        width = max_len[i] + 1
        method_name = 'rjust' if isinstance(s[i], int) else 'ljust'
        part = getattr(str(s[i]), method_name)(width)[:width]
        args.append(part)

    result = '│{0}│{1}│{2}│{3}│{4}│{5}│{6}│{7}│'.format(*tuple(args))
    return result


def title_line(max_len):
    args = []
    for i in range(len(max_len)):
        width = max_len[i] + 1
        method_name = titles[i][1]
        part = getattr(titles[i][0], method_name)(width)[:width]
        args.append(part)

    result = '│{0}│{1}│{2}│{3}│{4}│{5}│{6}│{7}│'.format(*tuple(args))
    return result


def main():
    a = sys.argv
    versions = get_versions()
    print(versions)
    if not len(a) == 2 or a[1] not in versions:
        print('Give single argument, one of: {} '.format(versions))
        print('Will use {}'.format(versions[0]))
        version = versions[0]
    else:
        version = a[1]
    stats = get_stats(version)
    print('ВСИЧКИ МОДУЛИ')
    sms = stats_max_lengths_sums(stats)
    max_len = sms['max_len']
    sums = sms['sums']

    print(max_len)
    print(sums)
    s = start(max_len)
    d = divider(max_len)
    e = end(max_len)
    el = ellipsis(max_len)
    print(s)
    print(title_line(max_len))
    print(d)
    for s in stats:
        print(stat_line(max_len, s))
    print(d)
    print(stat_line(max_len, sums))
    print(e)

    print('НЕДОПРЕВЕДЕНИ МОДУЛИ')
    stats = [s for s in stats if s.work > 0]
    sms = stats_max_lengths_sums(stats)
    max_len = sms['max_len']
    sums = sms['sums']

    print(max_len)
    print(sums)
    s = start(max_len)
    d = divider(max_len)
    e = end(max_len)
    el = ellipsis(max_len)
    print(s)
    print(title_line(max_len))
    print(d)
    for s in stats:
        print(stat_line(max_len, s))
    print(el)
    print(d)
    print(stat_line(max_len, sums))
    print(e)



    
if __name__ == '__main__':
    main()




