#!/usr/bin/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, print_function

import urllib2 as u2
import xml.etree.ElementTree as ET
import collections as col
import sys

titles = {'count': 'Номе',
          'name': 'Име',
          'branch': 'Клон',
          'work':'Работ',
          'untranslated': 'Непре',
          'fuzzy': 'Мъгля',
          'translated': 'Превед',
          'total': 'Всичко'}

def get_versions():
    versions_url = 'https://l10n.gnome.org/releases/xml'
    versions_data = u2.urlopen(versions_url)

    versions_tree = ET.parse(versions_data)
    versions_root = versions_tree.getroot()
    versions_xpath = './object/field[@name="name"]'
    version_elements = versions_root.findall(versions_xpath)
    versions = [e.text for e in version_elements]
    return versions

def get_stats(version):
    stats_url = 'https://l10n.gnome.org/languages/bg/{}/xml'.format(version)
    stats_data = u2.urlopen(stats_url)
    stats_tree = ET.parse(stats_data)
    stats_root = stats_tree.getroot()
    stats_xpath = './category/module'
    stats_elements = stats_root.findall(stats_xpath)
    results = []
    for stats_el in stats_elements:
        stat_id = stats_el.attrib['id']
        stat_branch = stats_el.attrib['branch']
        domains = stats_el.findall('./domain')
        for dom in domains:
            dom_id = dom.attrib['id']
            if dom_id == 'po':
                name = stat_id
            elif dom_id.startswith('po-'):
                name = '{}-{}'.format(stat_id, dom_id[3:])
            else:
                name = '{}-{}'.format(stat_id ,dom_id)
            translated = int(dom.findtext('./translated'))
            fuzzy = int(dom.findtext('./fuzzy'))
            untranslated  = int(dom.findtext('./untranslated'))
            work = fuzzy + untranslated
            total = work + translated
            s = {'name': name,
                 'branch': stat_branch,
                 'translated': translated,
                 'fuzzy': fuzzy,
                 'untranslated': untranslated,
                 'work': work,
                 'total': total} 
            results.append(s)
    return results

def stats_max_lengths_sums(stats):
    string_keys = [ 'name', 'branch']
    number_keys = ['translated', 'fuzzy', 'untranslated', 'work', 'total']
    string_lengths = {k: 0 for k in string_keys}
    number_sums = {k: 0 for k in number_keys}
    for s in stats:
        string_lengths = {k: max(string_lengths[k], len(s[k])) for k in ['name', 'branch']}
        number_sums = {k: number_sums[k] + s[k] for k in number_keys}

    lengths = {k: len(str(number_sums[k])) for k in number_keys}
    lengths.update(string_lengths)
    lengths['count']=len(str(len(stats)))
    return lengths, number_sums

def display_max_lengths(lengths):
    result = {k:max(len(titles[k]), lengths[k]) for k,v in titles.items()}
    return result

def divider(lengths):
    
    result = ('-' * (1 + lengths['count']) + '+' +
              '-' * (1 + lengths['name']) + '+' +
              '-' * (1 + lengths['branch']) + '+' +
              '-' * (1 + lengths['work']) + '+' +
              '-' * (1 + lengths['untranslated']) + '+' +
              '-' * (1 + lengths['fuzzy']) + '+' +
              '-' * (1 + lengths['translated']) + '+' +
              '-' * (1 + lengths['total']))                  

    return result

def ljust(length, sth):
    s = str(sth)
    result = (s + ' ' * length)[:length+1]
    #print('ljust', length, sth, '>'+result+'<')
    return result

def rjust(length, sth):
    s = str(sth)
    result = (' ' * length + s)[-length:]
    #print('rjust', length, sth, '>'+result+'<')
    return result

def line(lengths, stat):
    result = (rjust(lengths['count'], stat['count']) + '|' +
              ljust(lengths['name'], stat['name']) + '|' +
              ljust(lengths['branch'], stat['branch']) + '|' +
              rjust(lengths['work'], stat['work']) + '|' +
              rjust(lengths['untranslated'], stat['untranslated']) + '|' +
              rjust(lengths['fuzzy'], stat['fuzzy']) + '|' +
              rjust(lengths['translated'], stat['translated']) + '|' +
              rjust(lengths['total'], stat['total']))
    return result

def main():
    #a = sys.args
    #versions = get_versions()
    #if not len(a) == 1 or a[0] not in versions:
    #    print('Give single argument, one of: {} '.format(versions))
    #    print('Will use {}'.format(versions[0]))
    stats = get_stats('gnome-3-18')
    # sorts are stable
    stats.sort(key=lambda s: s['name'])
    stats.sort(key=lambda s: s['fuzzy'], reverse=True)
    stats.sort(key=lambda s: s['untranslated'], reverse=True)
    stats.sort(key=lambda s: s['work'], reverse=True)
    print(stats)
    lengths, sums = stats_max_lengths_sums(stats)
    print(lengths)
    print(divider(lengths))
    lengths = display_max_lengths(lengths)
    print(lengths)
    print(divider(lengths))
    i = 1
    for s in stats:
        s['count'] = i
        i+=1
        print(line(lengths, s))
    print(sums)
              
if __name__ == '__main__':
    main()




