#!/usr/bin/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, print_function

import urllib2 as u2
import xml.etree.ElementTree as ET
import collections as col
import sys


def get_versions():
    versions_url = 'https://l10n.gnome.org/releases/xml'
    versions_data = u2.urlopen(versions_url)

    versions_tree = ET.parse(versions_data)
    versions_root = versions_tree.getroot()
    versions_xpath = './object/field[@name="name"]'
    version_elements = versions_root.findall(versions_xpath)
    versions = [e.text for e in version_elements]
    return versions

def get_stats(version):
    stats_url = 'https://l10n.gnome.org/languages/bg/{}/xml'.format(version)
    stats_data = u2.urlopen(stats_url)
    stats_tree = ET.parse(stats_data)
    stats_root = stats_tree.getroot()
    stats_xpath = './category/module'
    stats_elements = stats_root.findall(stats_xpath)
    results = []
    for stats_el in stats_elements:
        stat_id = stats_el.attrib['id']
        stat_branch = stats_el.attrib['branch']
        domains = stats_el.findall('./domain')
        for dom in domains:
            dom_id = dom.attrib['id']
            if dom_id == 'po':
                name = stat_id
            elif dom_id.startswith('po-'):
                name = stat_id + ' • ' + dom_id[3:]
            else:
                name = stat_id + ' • ' + dom_id
            translated = int(dom.findtext('./translated'))
            fuzzy = int(dom.findtext('./fuzzy'))
            untranslated  = int(dom.findtext('./untranslated'))
            work = fuzzy + untranslated
            s = {'name': name,
                 'branch': stat_branch,
                 'translated': translated,
                 'fuzzy': fuzzy,
                 'untranslated': untranslated,
                 'work': work} 
            results.append(s)
    return results

def max_lengths(stats):
    result = {'name': 0,
              'branch': 0,
              'translated': 0,
              'fuzzy': 0,
              'untranslated': 0,
              'work': 0}
    for s in stats:
        print(s)
        result = {k:max(result[k], len(str(s[k]))) for k,v in result.items()}

    result['count']=int(str(len(stats)))

def main():
    #a = sys.args
    #versions = get_versions()
    #if not len(a) == 1 or a[0] not in versions:
    #    print('Give single argument, one of: {} '.format(versions))
    #    print('Will use {}'.format(versions[0]))
    stats = get_stats('gnome-3-18')
    print(stats)
    print(max_lengths(stats))

              
if __name__ == '__main__':
    main()




