#!/bin/bash
# http://l10n.gnome.org/languages/bg/ - editions
# gnome-3-0, freedesktop-org, gnome-gimp, etc

# When errors occur see the XML Interfaces section in https://wiki.gnome.org/DamnedLies

TMP=`mktemp`
CP="/usr/share/java/xalan-j2.jar:/usr/share/java/xalan-j2-serializer.jar:/usr/share/java/bsf.jar:/usr/share/java/commons-logging.jar:/usr/share/java/js.jar"
ED=$1; shift


# The new DamnedLies XML interface (around 2014-09-03) requires an
# edition in the URL. We are fetchig the first on the list. The
# assumtion is that it is the development relese a.k.a
# new-stable. This approach is kind of a hack. A better approach is
# desired.
if [ ! "$ED" ] ;
then
    rel=$(mktemp);
    wget --quiet -O $rel https://l10n.gnome.org/releases/xml 
    ED=$(grep -ioE  ".*\(development\)" -B1 $rel | grep -oE "gnome-[0-9\-]+");
    rm $rel   
fi

if [ ! "$ED" ];
then
    echo "Missing edition (i.e. gnome-3-14). Giving up!"
    exit 1
fi

wget http://l10n.gnome.org/languages/bg/$ED/xml -O $TMP
echo "Версия на GNOME: $ED"
java -cp $CP org.apache.xalan.xslt.Process -IN $TMP -XSL format.xsl
rm $TMP


