#!/bin/bash
SVNREPO=/var/local/svn/gtp
BACKUPDIR=/home/ash/public_html
DATE=`date +%Y%m%d`
MAILSUCCESS=dict-notifications@fsa-bg.org
MAILFAIL=dict@fsa-bg.org

svnadmin dump $SVNREPO | bzip2 > $BACKUPDIR/gtp.$DATE.bz2
if [ "x$?" != "x0" ]
 then mail -s "$DATE: Backup of gtp on fsa-bg.org FAILED!" $MAILFAIL <<EOF
===================
On $DATE
The backup of the repository http://zver.fsa-bg.org/repo/gtp
Which resides in /var/local/svn/gtp
To /home/ash/public_html
FAILED!
Please check and fix things!
===================
EOF
 else mail -s "$DATE: Backup of gtp on fsa-bg.org succeeded!" $MAILSUCCESS <<EOF
===================
On $DATE
The backup of the repository http://zver.fsa-bg.org/repo/gtp
Which resides in /var/local/svn/gtp
To /home/ash/public_html
Succeeded.
Please copy the generated file from
http://zver.fsa-bg.org/~ash/gtp.$DATE.bz2
===================
EOF
fi
