#!/bin/bash

if [ "x$1" == "x" ]; then
   echo 'First argument should be translator alias' >&2
   exit 1
fi
PERSON=$( sed -n "/^$1|/s/^$1|//p" << EOF
ash|Alexander Shopov <ash@contact.bg>
ilia|Ilia Penev <picholicho@gmail.com>
vic|Victor Dachev <vdachev@gmail.com>
vlad|Vladimir Petkov <kaladan@gmail.com>
ya|Yavor Doganov <yavor@gnu.org>
ys|Yassen Pramatarov <yassen@lindeas.com>
EOF
)

if [ "x$PERSON" == "x" ] 
 then
   echo 'Unknown translator' >&2
   exit 2
fi

DATE=$(date +%Y-%m-%d)

if [ ! -f ChangeLog ]; then
    echo  'No ChangeLog file' >&2
    exit 3
fi

svn revert ChangeLog
svn up ChangeLog

TMPFILE=$( mktemp -t ChangeLog.XXXXXXXXXX )

if [ $? -ne 0 ]; then
   echo 'Unable to make temp file' >&2
   exit 4
fi

cat << EOF >>$TMPFILE
$DATE  Alexander Shopov  <ash@contact.bg>

	* bg.po: Updated Bulgarian translation by
	$PERSON

EOF

cat ChangeLog >> $TMPFILE

mv $TMPFILE ChangeLog

if [ $? -ne 0 ]; then
   echo 'Unable to move temp file' >&2
   exit 5
fi

